/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.sonarlint.eclipse.core.internal.builder.SonarLintBuilder;

public class NewProjectListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            List<IProject> projects = NewProjectListener.getProjects(event.getDelta());
            for (final IProject p : projects) {
                new WorkspaceJob("Enable SonarLint builder"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        SonarLintBuilder.addBuilder(p);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    private static List<IProject> getProjects(IResourceDelta delta) {
        final ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IProject project;
                    if (delta.getKind() == 1 && delta.getResource().getType() == 4 && (project = (IProject)delta.getResource()).isAccessible()) {
                        projects.add(project);
                    }
                    return delta.getResource().getType() == 8;
                }
            });
        }
        catch (CoreException e) {
            throw new IllegalStateException(e);
        }
        return projects;
    }
}

